/*    
 ADF-Copy Frontend - Copyright (C) 2016 Dominik Tonn (nick@niteto.de)
 visit http://nicklabor.niteto.de for Infos and Updates
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

String version = "v0.967";
String firmware = "unknown";

import java.io.DataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
//import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.awt.*;

String fileName = "test.adf"; // fill in
String filePath = "";

import processing.serial.*;
import g4p_controls.*;
import static javax.swing.JOptionPane.*;
import jssc.*;


int bgcolor;			     // Background color
int fgcolor;			     // Fill color
Serial myPort;                       // The serial port
byte[] readString = new byte[512*11];
int readPtr;
long errormap[] = new long[160];
volatile color trackmap[] = new color[160]; 
int weak[] = new int[160];
boolean abort = false;
String extError;
int lf = 10;
byte track[] = new byte[512*11];
byte trackComp[] = new byte[512*11];
long hist[][] = new long [160][256];
boolean verify = false;
PGraphics upperGrid;
PGraphics lowerGrid;
PGraphics flux;
PGraphics progress;
PGraphics status;
PGraphics logo;
PGraphics diskImage;
PImage checkmark;
PImage disk;
boolean diskChange = false;
int k = 0;
boolean ignoreChksumErr = true;
int mode = 0; // 0 = DD, 1 = HD
String pName;
String fileSep;

Font myFont;
String myFontName = "RobotoCondensed-Regular.ttf";
//String myFontName = "IndieFlower.ttf";
Float myFontSize = 13.0;
PFont myPFont;


void setup() {
  size(600, 420, JAVA2D);  // Stage size
  smooth(1);
  for (int i = 0; i<160; i++) {
    trackmap[i]=#ffffff;
  }
  int waitCounter = 0;
  surface.setTitle(version+": Loading Checkmark Image");
  checkmark = null;
  while (checkmark == null) {
    checkmark = loadImage("checkmark.png");
    waitCounter++;
    if (checkmark == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load checkmark image");
      System.exit(0);
    }
  }
  waitCounter = 0;
  surface.setTitle(version+": Loading InsertDisk Image");
  disk = null;
  while (disk == null) {
    disk = loadImage("InsertDisk.png");
    waitCounter++;
    if (disk == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load InsertDisk image");
      System.exit(0);
    }
  }
  upperGrid = createGraphics(170, 160);
  lowerGrid = createGraphics(170, 160);
  flux = createGraphics(360, 360);
  progress = createGraphics(160, 10);
  status = createGraphics(390, 20);
  logo = createGraphics(170, 127);
  diskImage = createGraphics(130, 131);
  diskImage.beginDraw();
  diskImage.image(disk, 0, 0);
  diskImage.endDraw();
  drawLogo(logo);
  drawProgress(progress, -1);
  grid(upperGrid, 0);
  grid(lowerGrid, 1);
  drawFlux(flux);
  initSerial();
  myPort.write("init\n");
  delay(200);
  myPort.clear();
  while (myPort.available()!=0) {
    print(myPort.readChar());
  }
  surface.setTitle(version+": Connecting to Hardware...");
  myPort.write("ver\n");
  while (myPort.available()==0) {
    delay(100);
  }
  firmware = myPort.readString();
  surface.setTitle(version+": Creating GUI");
  createGUI();
  try {
    myFont = java.awt.Font.createFont(Font.TRUETYPE_FONT, new File(dataPath("")+fileSep+myFontName)).deriveFont(myFontSize);
    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    //register the font
    ge.registerFont(Font.createFont(Font.TRUETYPE_FONT, new File(dataPath("")+fileSep+myFontName)));
  } 
  catch (IOException e) {
    e.printStackTrace();
  } 
  catch (FontFormatException e) {
    e.printStackTrace();
  }
  myPFont = createFont(myFontName, 14f);
  drawStatus(status, firmware);
  filename.setFont(myFont);
  filepathandname.setFont(myFont);
  label3.setFont(myFont);
  label4.setFont(myFont);
  verifyCheck.setFont(myFont);
  timeLabel.setFont(myFont);
  aboutP.setFont(myFont);
  closeB.setFont(myFont);
  chkSumChk.setFont(myFont);
  GButton.useRoundCorners(false);
  GCScheme.changePaletteColor(10, 2, color(150));
  GCScheme.changePaletteColor(10, 3, color(230));
  GCScheme.changePaletteColor(10, 4, color(200));
  GCScheme.changePaletteColor(10, 6, color(200));
  GCScheme.changePaletteColor(10, 14, color(200));
  color lightBlue = color(#ccccff);
  color darkBlue = color(#0b0b60);
  GCScheme.changePaletteColor(11, 2, color(50));
  GCScheme.changePaletteColor(11, 3, darkBlue);
  GCScheme.changePaletteColor(11, 4, lightBlue);
  GCScheme.changePaletteColor(11, 6, lightBlue);
  GCScheme.changePaletteColor(11, 14, lightBlue);
  closeB.setLocalColorScheme(11);
  enableButton(Init);
  enableButton(GetVN);
  enableButton(ADFRead);
  enableButton(ADFWrite);
  disableButton(StartRead);
  disableButton(StartWrite);
  disableButton(Abort);
  aboutP.setVisible(false);
  diskPanel.setVisible(false);
  filename.setTextEditEnabled(false);
  filepathandname.setTextEditEnabled(false);
  aboutText.setTextEditEnabled(false);
  aboutText.setText(
    "ADF-Copy - Frontend to Read and Write Amiga Floppy Disks\n"+
    "Copyright (C) 2016 Dominik Tonn (nick@niteto.de)\n"+
    "\n"+                    
    "visit http://nicklabor.niteto.de for Infos and Updates\n"+
    "\n"+                    
    "This program is free software: you can redistribute it and/or modify "+
    "it under the terms of the GNU General Public License as published by "+
    "the Free Software Foundation, either version 3 of the License, or "+
    "(at your option) any later version.\n"+
    "\n"+
    "This program is distributed in the hope that it will be useful, "+
    "but WITHOUT ANY WARRANTY; without even the implied warranty of "+
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the "+
    "GNU General Public License for more details.\n"+
    "\n"+
    "You should have received a copy of the GNU General Public License "+
    "along with this program.  \nIf not, see http://www.gnu.org/licenses/");
  surface.setIcon(checkmark);
}
void grid(PGraphics thisGrid, int side)
{
  int x = 15;
  int y = 15;
  thisGrid.beginDraw();
  thisGrid.background(230);
  thisGrid.stroke(0);
  thisGrid.textSize(14);
  thisGrid.textAlign(CENTER, CENTER);
  int size = 15;
  for (int i = 0; i<8; i++) {
    for (int j = 0; j<10; j++) {
      if (i==0) {
        thisGrid.fill(0, 0, 0);
        thisGrid.text(j, x+size/2+j*size, y-size/2-2);
        thisGrid.fill(255, 255, 255);
      }
      thisGrid.fill(trackmap[(j+i*10)*2+side]);
      //println(j+i*10);
      thisGrid.rect(x+j*size, y+i*size, size, size, 3);
      thisGrid.fill(255, 255, 255);
    }
    thisGrid.fill(0, 0, 0);
    thisGrid.text(i, x-size/2, size+y-size/2+i*size);
    thisGrid.fill(255, 255, 255);
  }
  thisGrid.fill(0, 0, 0);
  if (side==0) {
    thisGrid.text("Upper Side", x+75, y+130);
  } else {
    thisGrid.text("Lower Side", x+75, y+130);
  }
  thisGrid.fill(255, 255, 255);
  thisGrid.endDraw();
}

void draw() {
  surface.setTitle("ADF-Copy "+version);
  background(230);
  sP1.setGraphic(upperGrid);
  sP2.setGraphic(lowerGrid);
  fluxPad.setGraphic(flux);
  progressPad.setGraphic(progress);
  statusPad.setGraphic(status);
  logoPad.setGraphic(logo);
  diskPad.setGraphic(diskImage);
  sP1.draw();
  sP2.draw();
  fluxPad.draw();
  progressPad.draw();
  statusPad.draw();
  logoPad.draw();
}

String getExtErr()
{
  myPort.clear();
  myPort.write("exterr\n");
  while (myPort.available()==0) {
    delay(5);
  }
  return myPort.readString();
}

int getMode()
{
  myPort.clear();
  myPort.write("getmode\n");
  while (myPort.available()==0) {
    delay(5);
  }
  if (myPort.readString().charAt(0) =='H') {
    mode = 1;
  } else {
    mode = 0;
  }
  return mode;
}
char byte2char(byte c) {
  if ((c < 32) | (c > 126)) {
    return (char) 46;
  } else {
    return (char) c;
  }
}
void getWeak(int track)
{
  myPort.clear();
  myPort.write("weak\n");
  while (myPort.available()==0) {
    delay(5);
  }
  weak[track] = myPort.read();
  if (weak[track] > 2) {
    println("Track: "+track+" Retries: "+weak[track]);
    trackmap[track]=#ffff00;
  } else {
    trackmap[track]=#00ff00;
  }
}

void getFlux(int track)
{
  long a, b, c, d;
  long tHist;
  myPort.clear();
  myPort.write("flux\n");
  while (myPort.available()<1024) {
    delay(5);
  }
  for (int i = 0; i<256; i++) {
    a = myPort.read();
    b = myPort.read();
    c = myPort.read();
    d = myPort.read();
    tHist = (d<<24)+(c<<16)+(b<<8)+a;
    hist[track][i]=tHist;
  }
}

void drawProgress(PGraphics tP, int i)
{
  tP.beginDraw();
  tP.fill(255, 255, 255, 255);
  tP.noStroke();
  tP.rect(0, 0, 159, 9);
  tP.fill(0, 255, 0, 255);
  tP.noStroke();
  tP.rect(0, 0, i, 9);
  tP.endDraw();
}

void drawStatus(PGraphics tS, String text)
{
  if (text==null) text="Unknown Error";
  tS.beginDraw();
  tS.background(255);
  tS.textFont(myPFont);
  //  tS.textSize(12);
  tS.fill(0);
  tS.text(text, 2, 15);
  tS.endDraw();
}

void drawLogo(PGraphics tL)
{
  PImage img;
  PImage img2;
  int waitCounter = 0;
  surface.setTitle(version+": Loading Logo");
  img = null;
  while (img == null) {
    img = loadImage("logoblau.jpg");
    waitCounter++;
    if (img == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load Logo image");
      System.exit(0);
    }
  }
  waitCounter = 0;
  surface.setTitle(version+": Loading GPL-Logo");
  img2 = null;
  while (img2 == null) {
    img2 = loadImage("gplv3.png");
    waitCounter++;
    if (img2 == null) delay(1000);
    if (waitCounter==10) {
      showMessageDialog(frame, "Unable to load GPL image");
      System.exit(0);
    }
  }
  tL.beginDraw();
  //tL.background(255);
  tL.image(img, 0, 0);
  tL.image(img2, 70, 97, 100, 30);
  tL.textSize(14);
  tL.textAlign(CENTER, CENTER);
  tL.fill(255);
  tL.text(version, 35, 115);
  tL.fill(0, 0, 0, 0);
  tL.stroke(230);
  tL.strokeWeight(4);
  tL.rect(-1, -1, 172, 129, 10);
  tL.endDraw();
}

void drawFlux(PGraphics tF)
{
  tF.beginDraw();
  tF.background(230);
  long tHist;
  tF.fill(0, 102, 153);
  tF.stroke(0, 0, 0);
  tF.line(29, 331, 350, 331);
  tF.line(29, 331, 29, 28);
  tF.textSize(20);
  tF.textAlign(RIGHT, CENTER);
  tF.text("µs", 40, 400-2*199);
  tF.text("8", 20, 400-2*186);
  tF.line(24, 401-2*186, 34, 401-2*186);
  tF.text("6", 20, 400-2*138);
  tF.line(24, 401-2*138, 34, 401-2*138);
  tF.text("4", 20, 400-2*90);
  tF.line(24, 401-2*90, 34, 401-2*90);
  tF.textAlign(CENTER, CENTER);
  tF.text("0", 30, 340);
  tF.text("40", 180, 340);
  tF.text("79", 340, 340);
  //rect(40, 360, 320, 280, 7);
  for (int j =0; j<160; j++) {
    if (weak[j]>0) {
      if (weak[j]==25) {
        tF.stroke(255, 0, 0);
      } else {
        tF.stroke(180, 180-weak[j]*30, 180);
      }
      tF.line(30+j*2, 330, 30+j*2, 30);
    }
    for (int i = 50; i<200; i++) {
      tHist=hist[j][i];
      if (tHist>0) {
        tF.stroke(tHist/2, tHist/8, tHist/64);
        tF.rect(30+j*2, 400-i*2, 1, 1);
        //        point(40+j*2, 240+i*2);
        //        point(40+j*2+1, 240+i*2);
      }
    }
  }
  tF.endDraw();
}

void readSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
    disableButton(StartRead);
  } else {
    println("User selected " + selection.getAbsolutePath());
    fileName=selection.getAbsolutePath();
    filepathandname.setText(fileName);
    disableButton(StartWrite);
    enableButton(StartRead);
  }
}

void folderSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
  } else {
    println("User selected " + selection.getAbsolutePath());
    filePath=selection.getAbsolutePath();
    filepathandname.setText(filePath);
    myPort.write("init\n");
    myPort.clear();
    thread("autoRip");
  }
}

void writeSelected(File selection) {
  if (selection == null) {
    println("Window was closed or the user hit cancel.");
    disableButton(StartWrite);
  } else {
    println("User selected " + selection.getAbsolutePath());
    fileName=selection.getAbsolutePath();
    filepathandname.setText(fileName);
    disableButton(StartRead);
    enableButton(StartWrite);
  }
}

void getTracks()
{
  ignoreChksumErr=chkSumChk.isSelected();
  abort = false;
  enableButton(Abort);
  disableButton(Init);
  disableButton(AutoRip);
  disableButton(GetVN);
  disableButton(ADFRead);
  disableButton(ADFWrite);
  disableButton(StartRead);
  disableButton(Cleaning);
  disableButton(StartWrite);
  for (int i = 0; i<160; i++)
  {
    weak[i]=0;
    errormap[i]=0;
    trackmap[i]=#ffffff;
    for ( int j=0; j<256; j++) {
      hist[i][j]=0;
    }
  }
  int start = 0;
  int stop = 160;
  int zeit = millis();
  long errors = 0;
  int failed = 0;
  String tempString;
  boolean retry = false;
  int sectors = 11;
  String extError;
  myPort.clear();
  try {
    FileOutputStream fstream = new FileOutputStream(fileName);
    BufferedOutputStream bstream = new BufferedOutputStream(fstream);
    DataOutputStream dstream = new DataOutputStream(bstream);
    drawStatus(status, "Reading Tracks...");

    for (int i = start; i<stop; i++) {
      if (abort==true) {
        //abort = false;
        drawStatus(status, "Aborting by User request...");
        break;
      }
      drawProgress(progress, i);
      myPort.write("get "+i+"\n");
      //println("error");
      myPort.write("error\n");
      while (myPort.available()==0) {
        delay(5);
      }
      tempString = trim(myPort.readString());
      errormap[i] = Long.parseLong(tempString);
      if (errormap[i]==-1) {
        extError = getExtErr();
        drawStatus(status, "Fatal Error Track " + i+ ": "+extError);
        if (showConfirmDialog(frame, "Retry?", extError+" at Track "+i, YES_NO_OPTION)==1)
        {
          failed = -1;
          break;
        } else {
          retry = true;
        }
      }       
      //      myPort.clear();
      //println("weak");
      getWeak(i);
      drawStatus(status, "Track: " + i+" Errors: "+errors);
      if (errormap[i]!=0) {
        errors++;
        trackmap[i]=#ff0000;
        if (ignoreChksumErr==false) {
          if (showConfirmDialog(frame, "Retry?", "Checksum error at Track "+i, YES_NO_OPTION)!=1)
          {
            retry = true;
          }
        }
      }
      //println("dump");
      getFlux(i);
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
      drawFlux(flux);
      if (getMode()==1) {
        sectors=22;
      } else {
        sectors=11;
      }

      myPort.write("download\n");
      while (myPort.available()<512*sectors) {
        delay(10);
      }
      track = myPort.readBytes();

      if (retry==false) dstream.write(track, 0, 512*sectors);
      timeLabel.setText("Time remaining: "+((millis()-zeit)*160/(i+1)-(millis()-zeit))/1000+"s");
      //println("flux");
      if (retry) {
        i--;
        retry = false;
      }
    }
    dstream.close();
    zeit = millis()-zeit;
    if (failed == 0) {
      drawStatus(status, "Download complete. "+(stop-start)+" Tracks read in "+(zeit/1000)+" Seconds");
      PrintWriter logFile;
      logFile = createWriter(fileName+".log");
      for (int i = start; i<stop; i++) {
        if (errormap[i]!=0) {
          logFile.println("Bad Track #"+i+parseError(errormap[i]));
        }
        if ((weak[i]>1)&&(errormap[i]==0)) {
          logFile.println("possible Weak Track #"+i+", needed "+weak[i]+" retries.");
        }
      }
      logFile.flush();
      logFile.close();
      noLoop();
      redraw();
      flux.save(fileName+".jpg");
      loop();
      timeLabel.setText("Done");
    }
  }   
  catch(IOException e) {
    println("IOException");
    e.printStackTrace();
  }
  enableButton(Init);
  enableButton(GetVN);
  enableButton(ADFRead);
  enableButton(ADFWrite);
  enableButton(AutoRip);
  enableButton(StartRead);
  enableButton(Cleaning);
  disableButton(Abort);
  myPort.write("init\n");
}

void cleanDrive()
{
  abort = false;
  enableButton(Abort);
  disableButton(AutoRip);
  disableButton(Init);
  disableButton(GetVN);
  disableButton(ADFRead);
  disableButton(ADFWrite);
  disableButton(StartRead);
  disableButton(StartWrite);
  disableButton(Cleaning);
  myPort.clear();
  for (int i = 0; i<160; i++)
  {
    trackmap[i]=#ffffff;
  }
  String temp = dropList1.getSelectedText();
  temp = temp.replace(" sec", "");
  int tDuration = int(temp);
  int i = 0;
  int secs= 0;
  int zeit = millis();
  drawStatus(status, "Moving Head around...");
  int duration = zeit + tDuration*1000;
  while (duration > millis()) {
    if (abort==true) {
      abort = false;
      drawStatus(status, "Aborting by User request...");
      break;
    }
    trackmap[i*2]=#00ffff;
    trackmap[i*2+1]=#00ffff;
    myPort.write("goto "+i*2+"\n");
    drawStatus(status, "Track: " + i);
    i = (i + 6)%80;
    grid(upperGrid, 0);
    grid(lowerGrid, 1);
    secs = (duration - millis())/1000;
    timeLabel.setText("Time remaining: "+secs+"s");
    drawProgress(progress, int(160-(160/float(tDuration)*secs)));
    delay(1000);
    secs = (duration - millis())/1000;
    timeLabel.setText("Time remaining: "+secs+"s");
    drawProgress(progress, int(160-(160/float(tDuration)*secs)));
    delay(1000);
  }
  enableButton(Init);
  enableButton(GetVN);
  enableButton(AutoRip);
  enableButton(ADFRead);
  enableButton(ADFWrite);
  enableButton(StartRead);
  enableButton(Cleaning);
  disableButton(Abort);
  myPort.write("init\n");
}

void enableButton(GImageButton button)
{
  button.setEnabled(true);
  button.setAlpha(255);
}

void disableButton(GImageButton button)
{
  button.setEnabled(false);
  button.setAlpha(50);
}

String getName()
{
  myPort.clear();
  myPort.write("name\n");
  while (myPort.available()==0) {
    delay(5);
  }
  return trim(myPort.readString());
}

void autoRip()
{
  enableButton(Abort);
  disableButton(Init);
  disableButton(GetVN);
  disableButton(ADFRead);
  disableButton(ADFWrite);
  disableButton(AutoRip);
  disableButton(StartWrite);
  disableButton(StartRead);
  disableButton(Cleaning);
  myPort.clear();
  abort=false;
  diskChange=false;
  while (abort==false)
  {
    while (diskChange==false && abort==false) {
      myPort.write("dskcng\n");
      while (myPort.available()==0) {
        delay(5);
      }
      delay(1000);
      if (Integer.valueOf(trim(myPort.readString()))==0)
      {
        diskChange = false;
        diskPanel.setVisible(true);
      } else {
        diskChange = true;
        diskPanel.setVisible(false);
      }
    }
    if (abort==true) break;
    myPort.write("init\n");
    myPort.clear();
    delay(200);

    fileName = getName();
    filename.setText(fileName);
    fileName = filePath+fileSep+fileName.replaceAll("[#<>$+%!´`&*\"|{}?=/:\\@]", "_")+"_"+Long.toHexString(System.currentTimeMillis())+".adf";
    filepathandname.setText(fileName);
    myPort.write("init\n");
    myPort.clear();
    delay(200);
    println("Ripping: "+fileName);
    getTracks();
    disableButton(Init);
    disableButton(AutoRip);
    disableButton(GetVN);
    disableButton(ADFRead);
    disableButton(ADFWrite);
    disableButton(StartRead);
    disableButton(Cleaning);
    disableButton(StartWrite);
    enableButton(Abort);
    myPort.write("init\n");
    myPort.clear();
    while (diskChange==true && abort==false) {
      delay(1000);
      myPort.write("dskcng\n");
      while (myPort.available()==0) {
        delay(5);
      }
      if (Integer.valueOf(trim(myPort.readString()))==0)
      {
        diskChange = false;
      } else {
        diskChange = true;
        diskPanel.setVisible(true);
      }
    }
  }
  abort = false;
  drawStatus(status, "Aborting by User request...");
  diskPanel.setVisible(false);
  enableButton(Init);
  enableButton(GetVN);
  enableButton(ADFRead);
  enableButton(ADFWrite);
  enableButton(AutoRip);
  enableButton(Cleaning);
  disableButton(Abort);
}



int waitForDiskChange()
{
  int diskChange = 0;
  int diskChangeCount = 0;
  myPort.clear();
  while (diskChange==0)
  {
    myPort.write("dskcng\n");
    while (myPort.available()==0) {
      delay(5);
    }
    diskChange = Integer.valueOf(trim(myPort.readString()));
    diskChangeCount++;
    if (diskChangeCount >5) {
      return -1;
    }
  }
  return 1;
}


void putTracks()
{
  int retries= 0;
  verify=verifyCheck.isSelected();
  abort = false;
  enableButton(Abort);
  disableButton(AutoRip);
  disableButton(Cleaning);
  disableButton(Init);
  disableButton(GetVN);
  disableButton(ADFRead);
  disableButton(ADFWrite);
  disableButton(StartRead);
  disableButton(StartWrite);
  myPort.clear();
  for (int i = 0; i<160; i++)
  {
    weak[i]=0;
    errormap[i]=0;
    trackmap[i]=#ffffff;
    for ( int j=0; j<256; j++) {
      hist[i][j]=0;
    }
  }
  drawFlux(flux);
  int start = 0;
  int stop = 160;
  int zeit = millis();
  long errors = 0;
  int failed = 0;
  String tempString;
  boolean retry = false;
  int trackSize = 5632;
  byte image[] = loadBytes(fileName);
  if (image==null) {
    drawStatus(status, "Error reading Image");
    enableButton(Init);
    enableButton(GetVN);
    enableButton(ADFRead);
    enableButton(ADFWrite);
    enableButton(StartWrite);
    enableButton(AutoRip);
    enableButton(Cleaning);
    disableButton(Abort);
    return;
  }
  boolean HDImage = false;
  int imageSize = image.length;
  switch (imageSize) {
  case 901120:
    HDImage = false;
    trackSize = 5632;
    break;
  case 1802240:
    HDImage = true;
    trackSize = 2*5632;
    drawStatus(status, "Writing HD isn't implemented yet.");
    showMessageDialog(frame, "Writing HD Images isn't implemented yet.", "Information", INFORMATION_MESSAGE);
    enableButton(Init);
    enableButton(GetVN);
    enableButton(ADFRead);
    enableButton(ADFWrite);
    enableButton(StartWrite);
    enableButton(AutoRip);
    enableButton(Cleaning);
    disableButton(Abort);
    return;
  default:    
    drawStatus(status, "Wrong Image size");
    showMessageDialog(frame, "Wrong Image Size", "Error", ERROR_MESSAGE);
    enableButton(Init);
    enableButton(GetVN);
    enableButton(ADFRead);
    enableButton(ADFWrite);
    enableButton(StartWrite);
    enableButton(AutoRip);
    enableButton(Cleaning);
    disableButton(Abort);
    return;
  }

  drawStatus(status, "Writing Tracks");
  myPort.write("init\n");
  delay(100);
  waitForDiskChange();
  if (HDImage) {
    myPort.write("setmode hd\n");
  } else {
    myPort.write("setmode dd\n");
  }
  while (myPort.available()<2) {
    delay(5);
  }
  tempString = trim(myPort.readString());
  for (int i = start; i<stop; i++) {
    if (abort==true) {
      abort = false;
      drawStatus(status, "Aborting by User request...");
      break;
    }
    waitForDiskChange();
    if (HDImage) {
      arrayCopy(image, i*512*22, track, 0, 512*11);
      myPort.write("upload\n");
      myPort.write(track);
      arrayCopy(image, (i*512*22)+512*11, track, 0, 512*11);
      myPort.write(track);
      while (myPort.available()<2) {
        delay(5);
      }
      tempString = trim(myPort.readString());
    } else {
      arrayCopy(image, i*512*11, track, 0, 512*11);
      myPort.write("upload\n");
      myPort.write(track);
      while (myPort.available()<2) {
        delay(5);
      }
      tempString = trim(myPort.readString());
    }
    myPort.write("put "+i+"\n");
    //    delay(250);
    while (myPort.available()==0) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    if (tempString.contains("OK")) {
      trackmap[i]=#0000ff;
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawProgress(progress, i);
    myPort.write("error\n");
    while (myPort.available()==0) {
      delay(5);
    }
    tempString = trim(myPort.readString());
    errors = Long.parseLong(tempString);
    if (errors==-1) {
      drawStatus(status, getExtErr()+" Aborting...");
      failed = -1;
      break;
    }
    if (verify) {
      myPort.write("get "+i+"\n");
      myPort.write("download\n");
      while (myPort.available()<trackSize) {
        delay(10);
      }
      trackComp = myPort.readBytes();
      getWeak(i);
      getFlux(i);
      drawFlux(flux);
      if (!Arrays.equals(track, trackComp)) {
        trackmap[i]=#ff0000;
        retry = true;
        retries++;
      } else {
        trackmap[i]=#00ff00;
        retries=0;
      }
      grid(upperGrid, 0);
      grid(lowerGrid, 1);
    }
    drawStatus(status, "Track: " + i + " Retries: " + retries);
    if (retries>10) {
      if (showConfirmDialog(frame, "Retry?", "Write error at Track "+i, YES_NO_OPTION)==1)
      {
        drawStatus(status, "Track " + i+" is unwritable. Aborting...");
        failed = -1;
        break;
      } else {
        retries = 0;
      }
    }
    timeLabel.setText("Time remaining: "+((millis()-zeit)*160/(i+1)-(millis()-zeit))/1000+"s");
    if (retry) {
      i--;
      retry = false;
    }
  }
  zeit = millis()-zeit;
  if (failed == 0) {
    drawStatus(status, "Write complete. "+(stop-start)+" Tracks written in "+(zeit/1000)+" Seconds");
    timeLabel.setText("Done");
  } else {
    timeLabel.setText("Error");
  }    
  enableButton(Init);
  enableButton(GetVN);
  enableButton(ADFRead);
  enableButton(ADFWrite);
  enableButton(StartWrite);
  enableButton(AutoRip);
  enableButton(Cleaning);
  disableButton(Abort);
  myPort.write("init\n");
}

void printBuffer() {
  for (int k = 0; k < 11; k++) {
    println("Sector "+k);
    for (int i = 0; i < 16; i++) {
      for (int j = 0; j < 32; j++) {
        System.out.printf("%02x", track[(i*32)+j+k*512]);
      }
      print(" ");
      for (int j = 0; j < 32; j++) {
        System.out.printf("%c", byte2char(track[(i*32)+j+k*512]));
      }
      println();
    }
  }
}

String parseError(long error)
{
  String tError="";
  if ((error&0xffffffff)!=0) {
    tError = " HeaderChkSum fail in Sector: ";
  }
  for (int i =0; i<32; i++) {
    if ((error&1)==1)
    {
      tError+=i+" ";
    }
    error=error>>1;
  }
  if ((error)!=0) {
    tError+=" DataChkSum fail in Sector: ";
  }
  for (int i =0; i<32; i++) {
    if ((error&1)==1)
    {
      tError+=i+" ";
    }
    error=error>>1;
  }
  return tError;
}

void initSerial()
{
  surface.setTitle(version+": Loading Native Serial Library");
  String osName = System.getProperty("os.name");
  String osArch = System.getProperty("os.arch");
  String libName = "";
  String osVersion = System.getProperty("os.version");
  fileSep = System.getProperty("file.separator");
  println(osName + " " + osArch + " " + osVersion);
  if (osName.startsWith("Win")) {
    if (osArch.equals("i386") || osArch.equals("i686") || osArch.equals("x86")) {
      libName=fileSep+"jSSC-2.8_x86.dll";
      version = version +" - "+osName+" 32 bit";
    } else if (osArch.equals("amd64") || osArch.equals("universal")) {
      libName=fileSep+"jSSC-2.8_x86_64.dll";
      version = version +" - "+osName+" 64 bit";
    }
  } else {
    if (osArch.equals("arm")) {
      libName=fileSep+"libjSSC-2.8_arm.so";
      version = version +" - "+ osName + " ARM "+osVersion;
    }
  }
  if (osName.startsWith("Linux")) {
    if (osArch.equals("i386") || osArch.equals("i686") || osArch.equals("x86")) {
      libName=fileSep+"libjSSC-2.8_linux32.so";
      version = version +" - "+osName+" 32 bit";
    } else if (osArch.equals("amd64") || osArch.equals("universal")) {
      libName=fileSep+"libjSSC-2.8_linux64.so";
      version = version +" - "+osName+" 64 bit";
    }
  }

  try {
    System.load(dataPath("")+libName);
  } 
  catch (UnsatisfiedLinkError e) {
    System.err.println("Native code library failed to load.\n" + e);
    version = version +".";
    showMessageDialog(frame, "Unsupported System: "+osName+" "+osArch+" "+osVersion);
    System.exit(0);
  }
  println("Loaded "+dataPath("")+libName);
  surface.setTitle(version+": Searching COM-Port");
  String COMx, COMlist = "";
  try {
    int i = Serial.list().length;
    if (i != 0) {
      if (i >= 2) {
        for (int j = 0; j < i; j++ ) {
          if (osName.startsWith("Win")) {

            COMlist += char(j+'a') + " = " + Serial.list()[j];
            //println(Serial.list()[j]);
            if (j < i) COMlist += ",  ";
          } else {
            if (Serial.list()[j].startsWith("/dev/ttyACM")) {
              COMlist += char(j+'a') + " = " + Serial.list()[j];
              //println(Serial.list()[j]);
              if (j < i) COMlist += ",  ";
            }
          }
        }
        if (COMlist.endsWith(",  ")) {
          COMlist = COMlist.substring(0, COMlist.length()-3);
        }
        COMx = showInputDialog("Which COM port is correct? (a,b,..):\n"+COMlist);
        if (COMx == null) exit();
        if (COMx.isEmpty()) exit();
        i = int(COMx.toLowerCase().charAt(0) - 'a') + 1;
      }
      String portName = Serial.list()[i-1];
      pName = portName;
      myPort = new Serial(this, portName, 230400);
    } else {
      showMessageDialog(frame, "Device is not connected to the PC");
      System.exit(0);
    }
  }
  catch (Exception e)
  { //Print the type of error
    showMessageDialog(frame, "COM port is not available (may\nbe in use by another program)");
    println("Error:", e);
    System.exit(0);
  }
}