/*
   Various defines and variables for ADF-Drive
*/

/* Debug and Modes */
// #define debug //uncomment for main debug messages
// #define Display //not yet implemented
#define mtpmode // enables USB MTP support
#define hdmode // enables HD Disk funktions
#include "adf_defines.h" //for adflib debugging message please edit adf_defines.h in the adf library folder
// #define debugmtp // mtp debug messages
// #define debugmtp2 // verbose mtp packet messages
#define errLed //enables error Led blink codes, disable when using SD Card pin 13 -> SCLK

/* flexible timer module */
#define timerModeHD 0x08    // TOF=0 TOIE=0 CPWMS=0 CLKS=01 (Sys clock) PS=000 (divide by 1)
#define timerModeDD 0x09    // TOF=0 TOIE=0 CPWMS=0 CLKS=01 (Sys clock) PS=001 (divide by 2)
#define filterSettingDD 0   // 4+4×val clock cycles, 48MHz = 4+4*2 = 32 clock cycles = 0.25us
#define filterSettingHD 0   // 4+4×val clock cycles, 48MHz = 4+4*2 = 32 clock cycles = 0.25us

#define motorMaxTick 5    // Idle Seconds before Motor off
#define sdRetries_ 10      // maximum retries to read a track
#define hdRetries_ 30      // maximum retries to read a track
#define transTimeDD 1.96    // timing for write transitions
#define transTimeHD 0.98    // timing for write transitions

#define FLOPPY_GAP_BYTES 1482
#define streamSizeHD 23*1088+FLOPPY_GAP_BYTES //22 sectors + gap + spare sector
#define streamSizeDD 12*1088+FLOPPY_GAP_BYTES //11 sectors + gap + spare sector
#define writeSizeDD 11*1088+FLOPPY_GAP_BYTES //11 sectors + xx bytes gap
#define writeSizeHD 22*1088+FLOPPY_GAP_BYTES //22 sectors + xx bytes gap
#define MFM_MASK  0x55555555

/* timing defines for Teensy HD Disks */
#define tHDlow2 30
#define tHDhigh2 90
#define tHDhigh3 140
#define tHDhigh4 200
/* timing defines for Teensy DD Disks */
#define tDDlow2 30
#define tDDhigh2 99
#define tDDhigh3 155
#define tDDhigh4 255

#define HD 1
#define DD 0

/* extended error defines */
#define NO_ERR 0            // OK
#define WPROT_ERR 1         // Disk is write-protected
#define TIMEOUT_ERR 2       // Timeout in read operation
#define SEEK_ERR 3          // Seek error
#define NUMSECTOR_ERR 4     // Incorrect number of sectors on track
#define TRACK0_ERR 5        // Seek Error Track 0
#define SECBOUNDS_ERR 6     // Sector out of bounds
#define HEADERCHKSUM_ERR 10 // Header bad checksum
#define DATACHKSUM_ERR 11   // Data bad checksum
#define UPLOAD_ERR 20       // Track upload error

/* defines for error blink codes */
#define readError 0b0000000000010101
#define writeError 0b0000000101010101
#define memError 0b0000111100001111
#define hardError 0b0101010101010101

#define mtpModeOn 1

/* default EEProm settings and structure */
struct tSettings
{
  uint32_t versionNr = numVersion;
  uint32_t motorSpinupDelay = 600; // ms
  uint32_t motorSpindownDelay = 50; // µs
  uint32_t driveSelectDelay = 100; // µs
  uint32_t driveDeselectDelay = 5; // µs
  uint32_t setDirDelay = 5; // µs
  uint32_t setSideDelay = 150; // µs
  uint32_t stepDelay = 2; // µs
  uint32_t stepSettleDelay = 3; // ms
  uint32_t gotoTrackSettle = 18; //  ms
  uint32_t sdRetries = sdRetries_; //10
  uint32_t hdRetries = hdRetries_; //30
  uint32_t config = mtpModeOn;
  uint32_t reserved3 = 0xDEADDA7A;
  uint32_t reserved4 = 0xDEADDA7A;
  uint32_t reserved5 = 0xDEADDA7A;
  uint32_t reserved6 = 0xDEADDA7A;
  uint32_t reserved7 = 0xDEADDA7A;
  uint32_t checksum = 0x00000000;
};
struct tSettings settings;

// following macros were posted on stackoverflow by "steveha"
// https://stackoverflow.com/questions/11697820/how-to-use-date-and-time-predefined-macros-in-as-two-integers-then-stri
#define COMPUTE_BUILD_YEAR \
  ( \
    (__DATE__[ 7] - '0') * 1000 + \
    (__DATE__[ 8] - '0') *  100 + \
    (__DATE__[ 9] - '0') *   10 + \
    (__DATE__[10] - '0') \
  )

#define COMPUTE_BUILD_DAY \
  ( \
    ((__DATE__[4] >= '0') ? (__DATE__[4] - '0') * 10 : 0) + \
    (__DATE__[5] - '0') \
  )

#define BUILD_MONTH_IS_JAN (__DATE__[0] == 'J' && __DATE__[1] == 'a' && __DATE__[2] == 'n')
#define BUILD_MONTH_IS_FEB (__DATE__[0] == 'F')
#define BUILD_MONTH_IS_MAR (__DATE__[0] == 'M' && __DATE__[1] == 'a' && __DATE__[2] == 'r')
#define BUILD_MONTH_IS_APR (__DATE__[0] == 'A' && __DATE__[1] == 'p')
#define BUILD_MONTH_IS_MAY (__DATE__[0] == 'M' && __DATE__[1] == 'a' && __DATE__[2] == 'y')
#define BUILD_MONTH_IS_JUN (__DATE__[0] == 'J' && __DATE__[1] == 'u' && __DATE__[2] == 'n')
#define BUILD_MONTH_IS_JUL (__DATE__[0] == 'J' && __DATE__[1] == 'u' && __DATE__[2] == 'l')
#define BUILD_MONTH_IS_AUG (__DATE__[0] == 'A' && __DATE__[1] == 'u')
#define BUILD_MONTH_IS_SEP (__DATE__[0] == 'S')
#define BUILD_MONTH_IS_OCT (__DATE__[0] == 'O')
#define BUILD_MONTH_IS_NOV (__DATE__[0] == 'N')
#define BUILD_MONTH_IS_DEC (__DATE__[0] == 'D')

#define COMPUTE_BUILD_MONTH \
  ( \
    (BUILD_MONTH_IS_JAN) ?  1 : \
    (BUILD_MONTH_IS_FEB) ?  2 : \
    (BUILD_MONTH_IS_MAR) ?  3 : \
    (BUILD_MONTH_IS_APR) ?  4 : \
    (BUILD_MONTH_IS_MAY) ?  5 : \
    (BUILD_MONTH_IS_JUN) ?  6 : \
    (BUILD_MONTH_IS_JUL) ?  7 : \
    (BUILD_MONTH_IS_AUG) ?  8 : \
    (BUILD_MONTH_IS_SEP) ?  9 : \
    (BUILD_MONTH_IS_OCT) ? 10 : \
    (BUILD_MONTH_IS_NOV) ? 11 : \
    (BUILD_MONTH_IS_DEC) ? 12 : \
    /* error default */  99 \
  )

#define COMPUTE_BUILD_HOUR ((__TIME__[0] - '0') * 10 + __TIME__[1] - '0')
#define COMPUTE_BUILD_MIN  ((__TIME__[3] - '0') * 10 + __TIME__[4] - '0')
#define COMPUTE_BUILD_SEC  ((__TIME__[6] - '0') * 10 + __TIME__[7] - '0')

#define BUILD_DATE_IS_BAD (__DATE__[0] == '?')

#define BUILD_YEAR  ((BUILD_DATE_IS_BAD) ? 99 : COMPUTE_BUILD_YEAR)
#define BUILD_MONTH ((BUILD_DATE_IS_BAD) ? 99 : COMPUTE_BUILD_MONTH)
#define BUILD_DAY   ((BUILD_DATE_IS_BAD) ? 99 : COMPUTE_BUILD_DAY)

#define BUILD_TIME_IS_BAD (__TIME__[0] == '?')

#define BUILD_HOUR  ((BUILD_TIME_IS_BAD) ? 99 :  COMPUTE_BUILD_HOUR)
#define BUILD_MIN   ((BUILD_TIME_IS_BAD) ? 99 :  COMPUTE_BUILD_MIN)
#define BUILD_SEC   ((BUILD_TIME_IS_BAD) ? 99 :  COMPUTE_BUILD_SEC)

/* reset macro */
#define CPU_RESTART_ADDR (uint32_t *)0xE000ED0C
#define CPU_RESTART_VAL 0x5FA0004
#define CPU_RESTART (*CPU_RESTART_ADDR = CPU_RESTART_VAL);
